#!/bin/bash
# IBM_PROLOG_BEGIN_TAG 
# This is an automatically generated prolog. 
#  
#  
#  
# Licensed Materials - Property of IBM 
#  
# Restricted Materials of IBM 
#  
# (C) COPYRIGHT International Business Machines Corp. 2003,2004 
# All Rights Reserved 
#  
# US Government Users Restricted Rights - Use, duplication or 
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
#  
# IBM_PROLOG_END_TAG 
####################################################################
#
#   chswnm command
#
#   Syntax:  chswnm [ -a | -d | -q | -r
#                             | --help ] 
#
#            --help   - Prints this message
#            -a       - Used to activate the SNM software by uncommenting the
#                          /etc/inittab entry for startFNMD
#            -d       - Used to deactivate the SNM software by commenting out 
#                          the /etc/inittab entry for startFNMD
#            -q       - Used to query the activation status of the SNM software
#                          by examining the /etc/inittab entry for startFNMD
#            -r       - Used by RestoreSNMUpgradeData to uncomment the
#                          /etc/inittab entry for startFNMD
#
####################################################################
#
#   Initial version - 02/26/03
#
####################################################################
#"@(#)35   1.5   src/hmcpok/commands/chswnm.bash, fnm.websm, hmcpok_rel1, rel1s006e 2/18/04 14:30:41"

PRGRM="chswnm"
AFLAG=0
DFLAG=0
QFLAG=0
RFLAG=0

USAGE="Usage: chswnm { -a | -d | -q | -r | --help }"

# First check for existence of parameters, then check validity
if (( $# != 1 ))
then
	echo $USAGE
	exit 2
else
    while test -n "$1"
        do
            case $1 in
                -a) AFLAG=1; break;;
                -d) DFLAG=1; break;;
                -q) QFLAG=1; break;;
                -r) RFLAG=1; break;;
                 *) echo $USAGE; exit 2;;
            esac
        done
fi

# Now make sure we are executing cut from the right path.  IN RedHat, it is
#   in /bin.  In MCP, it is in /usr/bin
if [[ -a /bin/cut ]]
then
	CUT=/bin/cut
else
	CUT=/usr/bin/cut
fi

# For -q, we query whether or not SNM software is enabled in /etc/inittab
if [ $QFLAG -eq 1 ]
then
	# Perform the query function
	grep_results=`/bin/grep startFNMD /etc/inittab`
	if [[ $grep_results == "" ]]
	then
		# No entry in /etc/inittab - should not happen
		echo 2;
		exit 2
	fi

	first_char=`echo $grep_results | $CUT -c 1`
	if [[ $first_char == "f" ]]
	then
		# SNM software is activated
		echo "0"
		exit 0
	else
		# SNM software is de-activated
		echo "1"
		exit 1
	fi
fi

# For -a, perform the activate SNM software function
if [ $AFLAG -eq 1 ]
then
	#Perform the activate function - first see if it is already activated
	grep_results=`/bin/grep startFNMD /etc/inittab`
	if [[ $grep_results == "" ]]
	then
		# No entry in /etc/inittab - should not happen
		echo 2;
		exit 2
	fi

	first_char=`echo $grep_results | $CUT -c 1`
	if [[ $first_char == "f" ]]
	then
		# SNM software is activated already
		echo "1"
		exit 1
	else
		# SNM software is de-activated - need to activate it
		# First remove the entry from /etc/inittab
		/bin/sed -e '/fnmd:/d' /etc/inittab > /tmp/hsc_tmp_inittab

		# Now add the uncommented entry and mv the file back
		echo "fnmd:2345:respawn:/opt/hsc/bin/startFNMD 1>/dev/null 2>&1" >> /tmp/hsc_tmp_inittab
		mv /tmp/hsc_tmp_inittab /etc/inittab

		# Set up the config file to be exec'ed
		rm -f /opt/hsc/data/SNMConfig
		echo "/opt/hsc/bin/chswnm.bash -r" > /opt/hsc/data/SNMConfig

		# Cause the file to be re-examined
		/sbin/telinit q

		# Now we wait
		# Use end as the while loop ending indicator, up is the
		#      signal that the daemon is up, and count will track
		#      how many sleep 5's we do.  If we get to 60, that's
		#      five minutes, and that's too long.
		end=0
		up=0
		count=0
		while test $end -eq 0
		do
			sleep 5
			num_grep_lines=`ps -ef | grep -c "/opt/hsc/bin/fnmd"`
			if [ $num_grep_lines -gt 4 ]
			then
					let up=$up+1
			fi
                        let  count=$count+1
                        if (($count == 60 || $up == 1))
			then
				end=1
                        fi
		done	

                if (($count == 60))
		then
			# We exited because 5 minutes are up
			echo "2"
			exit 2
		else
			echo "0"
			exit 0
		fi
	fi
fi

# For -r, uncomment the /etc/inittab entry for fnmd
if [ $RFLAG -eq 1 ]
then
	# First remove the entry from /etc/inittab
	/bin/sed -e '/fnmd:/d' /etc/inittab > /tmp/hsc_tmp_inittab

	# Now add the uncommented entry and mv the file back
	echo "fnmd:2345:respawn:/opt/hsc/bin/startFNMD 1>/dev/null 2>&1" >> /tmp/hsc_tmp_inittab
	mv /tmp/hsc_tmp_inittab /etc/inittab

	# Cause the file to be re-examined
	/sbin/telinit q
	exit 0
fi

# For -d, perform the de-activate SNM software function
if [ $DFLAG -eq 1 ]
then
	#Perform the de-activate function - first see if it is already de-activated
	grep_results=`/bin/grep startFNMD /etc/inittab`
	if [[ $grep_results == "" ]]
	then
		# No entry in /etc/inittab - should not happen
		echo 2;
		exit 2
	fi

	first_char=`echo $grep_results | $CUT -c 1`
	if [[ $first_char == "#" ]]
	then
		# SNM software is de-activated already
		echo "1"
		exit 1
	else
		# SNM software is activated - need to de-activate it
		# First remove the entry from /etc/inittab
		/bin/sed -e '/^fnmd:/d' /etc/inittab > /tmp/hsc_tmp_inittab

		# Now add the commented entry and mv the file back
		echo "#fnmd:2345:respawn:/opt/hsc/bin/startFNMD 1>/dev/null 2>&1" >> /tmp/hsc_tmp_inittab
		mv /tmp/hsc_tmp_inittab /etc/inittab

		# Set up the config file to be exec'ed
		rm -f /opt/hsc/data/SNMConfig
		echo "/opt/hsc/bin/chswnm.bash -q" > /opt/hsc/data/SNMConfig

		# Cause the file to be re-examined
		/sbin/telinit q
		echo "0"
		exit 0
	fi
fi

exit 0
